#version 150 
// hdr_exposure.fs
// Skaluje tekstur zmiennoprzecinkow do zakresu 0.0 - 1.0
// w okrelonym nawietleniu
// Rozwizuje bufor wieloprbkowania na podstawie liczby prbek wejciowych
// 

in vec2 vTexCoord;

uniform sampler2DMS origImage;
uniform samplerBuffer sampleWeightSampler; 
uniform int sampleCount; // Liczymy od zera, tzn. 0 = 1 prbka, 1 = 2 prbki itd.
uniform int useWeightedResolve; // 0-false, 1-true
uniform float exposure;

out vec4 oColor;

// Odwzorowywanie tonw wykonujemy w oddzielnej funkcji
vec4 toneMap(vec4 vHdrColor)
{
	vec4 vLdrColor;
	vLdrColor = 1.0 - exp2(-vHdrColor * exposure);
	vLdrColor.a = 1.0f;
	return vLdrColor;
}

void main(void) 
{ 
    // Obliczenie nieznormalizowanych wsprzdnych tekstury
	vec2 tmp = floor(textureSize2DMS(origImage) * vTexCoord); 

    // Znalezienie kolorw waonych i niewaonych
	vec4 vColor = vec4(0.0, 0.0, 0.0, 1.0);
	vec4 vWeightedColor = vec4(0.0, 0.0, 0.0, 1.0);
	
	for (int i = 0; i <= sampleCount; i++)
	{
	    // Pobranie wagi prbki z TBO, zmienia si
	    // w zalenoci od liczby prbek
	    float weight = texelFetch(sampleWeightSampler, i).r;
	    
	    // Odwzorowanie tonw teksela HDR przed jego waeniem
	    vec4 sample = toneMap(texelFetch(origImage, ivec2(tmp), i));
	    
		vWeightedColor += sample * weight;
		vColor += sample;
	}

    // Wybr rodzaju rozwizywania
    oColor = vWeightedColor;
	
	// Jeli uytkownik wybierze rozwizywanie niewaone, zwracamy
	// redni zwyk
	if (useWeightedResolve != 0)
	{
	    oColor = vColor / (sampleCount+1);    
	}

    oColor.a = 1.0f;
    
}